/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Toolkit source file
*
* Filename:                     tlk_odrm_version.h
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      26.12.2007
*
* Modified:                     26.12.2007
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_ODRM_VERSION_H_
#define _TLK_ODRM_VERSION_H_
#ifdef __cplusplus
extern "C" {
#endif  
#include "DX_VOS_BaseTypes.h"

    /************************ Defines ******************************/

    /* the TLK_ODRM release version definitions */

#define TLK_ODRM_RELEASE_TYPE         'A'
#define TLK_ODRM_MAJOR_VERSION_NUM     1
#define TLK_ODRM_MINOR_VERSION_NUM     0
#define TLK_ODRM_SUB_VERSION_NUM       7
#define TLK_ODRM_INTERNAL_VERSION_NUM  0

    /************************ Enums ********************************/

    /************************ Typedefs  ****************************/

#define DX_FW_COMPONENT_NAME_SIZE_IN_CHARS (9UL)

    /* @brief the version structure definition */
    typedef struct// todo raviv - move somewhere...
    {
        DxChar_t   componentName[DX_FW_COMPONENT_NAME_SIZE_IN_CHARS];
        DxUint32_t typeVer;
        DxUint32_t majorVer;
        DxUint32_t minorVer;
        DxUint32_t subVer;
        DxUint32_t internalVer;   
    }DXFWComponentVersion_t;

    typedef struct
    {
        DXFWComponentVersion_t tlk_odrm;
    }TLK_ODRMVersion_t;


    /************************ Public Functions **********************/
    /*TLK_ODRM_VersionGet*/
    /*!
    \brief    This function returns the TLK_ODRM version.

    @param[in] version_ptr - a pointer to the version structure.

    The release version number is handled by the following:

    D/B/R X1.X2.X3.X4

    The first letter defines the maturity of the release : 

    D  development , an internal release that passed maximim the unit tests.

    B  beta release , a release that usually passes the ATP by the QA.

    R  a formal release , passed all of the QA tests.


    X1  primary version  on our case it will be set as 6 ( when this version is updated all 
    of the lower ones X2,X3,X4 are reset to 0 ).

    X2  minor version  this number should be updated if a major feature is added or the API 
    interface has changed. ( when this version is updated X3,X4 are reset ).

    X3  sub versoion  on each new release passed to the QA this number should be incremented ( X4 is reset )

    X4  internal RD version , on each commit this number should be incremented , when the release is
    passed to the QA its reset and X3 is incremented. On each release send to customer this value should be 0.

    Note that releases passed to the customer have only 3 digits on the release R X1.X2.X3

    **/

    DxError_t TLK_ODRM_VersionGet(TLK_ODRMVersion_t *version_ptr);
#ifdef __cplusplus
}
#endif
#endif /* _TLK_ODRM_VERSION_H */
